#declare GOLDEN_RATIO = (1+sqrt(5))/2;






//-------------tools---------------------

#include "transforms.inc"


//------------------






#macro Data_Disk_Point_Sets(_resolution, _disk_pos, _disk_face, _disk_r, _return_pos, _return_v1, _return_v2)
//return an array that have three component
//

#if(_resolution < 1)
    #local res = 1;
#else
    #local res = int(_resolution);
#end
#local disk_pos = _disk_pos + <0,0,0>;
#local disk_face = vnormalize(_disk_face);
#local disk_v1 = VPerp_To_Vector(disk_face);
#local disk_v2 = vcross(disk_face, disk_v1);
#local disk_r = abs(_disk_r);


#local sample_pos = array[res]
#local sample_orient_v1 = array[res]
#local sample_orient_v2 = array[res]
#for(i, 0, res-1)
    #local sample_r = disk_r*sqrt(1/2 + i)/sqrt(res);
    #local sample_phi = i*2*pi*(1 - 1/GOLDEN_RATIO);
    #local sample_pos_origin = <sample_r*cos(sample_phi), sample_r*sin(sample_phi), 0>;
    #local sample_pos[i] = disk_pos + sample_pos_origin.x *disk_v1 + sample_pos_origin.y *disk_v2 + sample_pos_origin.z *disk_face;
    #local sample_orient_v1[i] = disk_v1;
    #local sample_orient_v2[i] = disk_v2;
#end

#local _return_pos = sample_pos;
#local _return_v1 = sample_orient_v1;
#local _return_v2 = sample_orient_v2;
#end




/**************************************************************************************************
generate a cylinder from point <0,0,0> to point <0,0,height> with radius r with a light bulb in it.
It will put four files in the folder, one the main include, one the light samples information file,
one the pretrace .pov file, and one the pretrace ini file.

**************************************************************************************************/
#macro Generate_Cylinder_Shade_Lighting(_light_name, _resolution, _light_bulb_radius, _light_bulb_z, _light_bulb_color, _cylinder_radius, _cylinder_height, _cylinder_diffuse_color, _cylinder_reflect)
//adjust inputs...
#local light_name = _light_name
#local scene_file_name = input_file_name

#if(_resolution < 1)
    #local res = 1;
#else
    #local res = int(_resolution);
#end
#local cylinder_r = abs(_cylinder_radius);
#local cylinder_hght = abs(_cylinder_height);
#if(_light_bulb_radius > cylinder_r)
    #local light_bulb_r = cylinder_r;
    #warning "radius of light bulb is bigger than cylinder"
#elseif(_light_bulb_radius <= 0)
    #error "radius of light bulb must be positive"
#else
    #local light_bulb_r = _light_bulb_radius;
#end
#if(_light_bulb_z <= light_bulb_r)
    #error "light bulb is too low"
#else
    #local light_bulb_z = _light_bulb_z;
#end
#local light_bulb_color_red = _light_bulb_color.red;
#local light_bulb_color_green = _light_bulb_color.green;
#local light_bulb_color_blue = _light_bulb_color.blue;
#local max_bright_color = max(light_bulb_color_red, light_bulb_color_green, light_bulb_color_blue);
#local light_bulb_color_red = light_bulb_color_red/max_bright_color;
#local light_bulb_color_green = light_bulb_color_green/max_bright_color;
#local light_bulb_color_blue = light_bulb_color_blue/max_bright_color;
#local cylinder_color_red = _cylinder_diffuse_color.red;
#local cylinder_color_green = _cylinder_diffuse_color.green;
#local cylinder_color_blue = _cylinder_diffuse_color.blue;
#local cylinder_reflect = abs(_cylinder_reflect);//
#if(cylinder_reflect > 1)
    #local cylinder_reflect = 1;
#end

#local light_pos_array = array[res]
#local light_v1_array = array[res]
#local light_v2_array = array[res]
Data_Disk_Point_Sets(res, <0,0,0>, -z, cylinder_r, light_pos_array, light_v1_array, light_v2_array)



//write files...
//main include file
#fopen light_include_file concat(light_name, ".inc") write
#write (light_include_file, "#local resolution = ")
#write (light_include_file, str(res,0,0), ";\n")
#write (light_include_file, "#declare ", light_name, "_lit_spl_pos_data = array[resolution]\n")
#write (light_include_file, "#declare ", light_name, "_lit_spl_v1_data = array[resolution]\n")
#write (light_include_file, "#declare ", light_name, "_lit_spl_v2_data = array[resolution]\n")
#write (light_include_file, "#local pos_temp = <0,0,0>;\n")
#write (light_include_file, "#local v1_temp = <0,0,0>;\n")
#write (light_include_file, "#local v2_temp = <0,0,0>;\n")
#write (light_include_file, "#local color_multi = ", max_bright_color, ";\n")
#write (light_include_file, "#local light_bulb_color = rgb <", light_bulb_color_red, ", ", light_bulb_color_green, ", ", light_bulb_color_blue, ">;\n")
#write (light_include_file, "#local cylinder_color = rgb <", cylinder_color_red, ", ", cylinder_color_green, ", ", cylinder_color_blue, ">;\n")
#write (light_include_file, "#local cylinder_reflection = ", cylinder_reflect, ";\n")
#write (light_include_file, "#local cylinder_r = ", cylinder_r, ";\n")
#write (light_include_file, "#local cylinder_hght = ", cylinder_hght, ";\n")
#write (light_include_file, "#local light_bulb_r = ", light_bulb_r, ";\n")
#write (light_include_file, "#local light_bulb_z = ", light_bulb_z, ";\n")
#write (light_include_file, "#local hypothesis_emission_area = pi*pow(cylinder_r,2);\n\n\n")
#write (light_include_file, "#fopen light_samples_info_file \"", concat(light_name, "_spl_info.txt"), "\" read\n")
#write (light_include_file, "#for(i, 0, resolution-1)\n")
#write (light_include_file, "    #read (light_samples_info_file, pos_temp)\n")
#write (light_include_file, "    #declare ", light_name, "_lit_spl_pos_data[i] = pos_temp;\n")
#write (light_include_file, "    #read (light_samples_info_file, v1_temp)\n")
#write (light_include_file, "    #declare ", light_name, "_lit_spl_v1_data[i] = v1_temp;\n")
#write (light_include_file, "    #read (light_samples_info_file, v2_temp)\n")
#write (light_include_file, "    #declare ", light_name, "_lit_spl_v2_data[i] = v2_temp;\n")
#write (light_include_file, "#end\n")
#write (light_include_file, "#fclose light_samples_info_file\n\n\n")
#write (light_include_file, "//------------emission object------------\n")
#write (light_include_file, "//You can modify this object yourself,\n")
#write (light_include_file, "//but notice that the emission object entirly should be above the x-y plane.\n")
#write (light_include_file, "//And it should not take any texture because the emission texture will be taken later.\n")
#write (light_include_file, "#local emission_object =\n")
#write (light_include_file,
"sphere{
<0, 0, light_bulb_z>, light_bulb_r
}\n\n\n")
#write (light_include_file, "//------------look like object------------\n")
#write (light_include_file, "//You can modify this object yourself,\n")
#write (light_include_file, "//but notice that this shape should be a downward shape and better fit a circle of radius cylinder_r at origin on the x-y plane.\n")
#write (light_include_file, "//You can give it some custom texture but it should not contain any emission component at all.\n")
#write (light_include_file, "#local lamp_look_like =\n")
#write (light_include_file, "union{\n")
#write (light_include_file,
"    cylinder{
    <0, 0, 0>, <0, 0, cylinder_hght>, cylinder_r
    open
        texture{
            pigment{color cylinder_color}
            finish{ambient 0 diffuse 1 reflection cylinder_reflection}
        }
    }
")
#write (light_include_file,
"    disc{
    <0, 0, cylinder_hght>, z, cylinder_r
        texture{
            pigment{color cylinder_color}
            finish{ambient 0 diffuse 1 reflection cylinder_reflection}
        }
    }
}
\n\n")
#write (light_include_file, "//------------hypothesis area shader------------\n")
#write (light_include_file, "//you should not modify this part\n")
#write (light_include_file, "#local hypothesis_area_shader =\n")
#write (light_include_file,
"disc{
<0, 0, 0>, z, cylinder_r
    texture{
        pigment{rgb<0,0,0>}
        finish{ambient 0 diffuse 1}
    }
    interior_texture{
        pigment{rgbt<0,0,0,1>}
        finish{ambient 0 diffuse 1}
    }
no_image
no_reflection
}
\n\n"
)
#write (light_include_file, "//------------light sources------------\n")
#write (light_include_file, "//you should not modify this part\n")
#write (light_include_file, "#ifdef(", light_name, "_pretrace)\n#else\n\n")
#write (light_include_file,
"#macro Factor_Color_Vs_Fade_Distance(_fade_distance)
(1/_fade_distance/_fade_distance/2)
#end\n"
)
#write (light_include_file,
"#if(resolution < 10)
    #local digit = 1;
#elseif(resolution < 100)
    #local digit = 2;
#elseif(resolution < 1000)
    #local digit = 3;",
"
#elseif(resolution < 10000)
    #local digit = 4;
#else
    #local digit = 5;
#end\n"
)
#write (light_include_file, "#local light_source_set =\n")
#write (light_include_file, "union{\n")
#write (light_include_file, "    #for(i, 0, resolution-1)\n")
#write (light_include_file, "        #local map_file_name_base = \"", light_name, "_pretrace\"\n")
#write (light_include_file,
"        #local map_file_name_number = str(i+1, -digit, 0)
        #local map_file_name = concat(map_file_name_base, map_file_name_number)
")
#write (light_include_file,
"        #local p_image =
        pigment{
            image_map {
            png map_file_name
            gamma 1.0
            map_type 1
            interpolate 2
            }
        rotate <90, 0, 0>
        scale <1,1,-1>
        }
")
#write (light_include_file,
"        #local f_image = function{pigment{p_image}}
        #local f_map = function(x,y,z){f_image(x,y,z).gray}
        #local p_map =
        pigment{",
"            function{f_map(x,y,z)}
            color_map{
            [0 rgbt<1,1,1,0>]
            [1 rgbt<1,1,1,1>]
            }
        }
\n")
#write (light_include_file,
"        union{
            light_source{
            <0,0,0>
            color light_bulb_color*color_multi*(hypothesis_emission_area/resolution/pi)*Factor_Color_Vs_Fade_Distance(0.001)",
"
            spotlight
            radius 90
            falloff 90
            tightness 1",
"
            point_at -z
            fade_power 2
            fade_distance 0.001
            }",
"
            sphere{
            <0,0,0>, 1
                texture{
                    pigment{p_map}
                    finish{ambient 0 diffuse 1}
                }",
"
            scale 0.0011
            no_image
            no_reflection
            no_radiosity
            }
")
#write (light_include_file,"        translate ", light_name, "_lit_spl_pos_data[i]\n        }\n")
#write (light_include_file, "        #undef f_image\n")
#write (light_include_file, "        #undef f_map\n")
#write (light_include_file, "    #end\n}\n\n\n")
#write (light_include_file, "#end //end if")
#write (light_include_file, "//------------declare objects------------\n")
#write (light_include_file, "//---------------------------------------\n")
#write (light_include_file, "#declare ", light_name, "_look_like_for_pretrace =\n")
#write (light_include_file,
"union{
    object{
    lamp_look_like
    }
    object{
    emission_object
        texture{
            pigment{color light_bulb_color}
            finish{ambient 0 diffuse 0 emission 1}
        }
    }
}
")
#write (light_include_file, "#ifdef(", light_name, "_pretrace)\n#else\n\n")
#write (light_include_file, "#declare ", light_name, " =\n")
#write (light_include_file,
"union{
    object{
    light_source_set
    }
    object{
    hypothesis_area_shader
    }
    object{
    lamp_look_like
    }",
"
    object{
    emission_object
        texture{
            pigment{color light_bulb_color*color_multi}
            finish{ambient 0 diffuse 0 emission 1}
        }
    no_radiosity
    }
}
")
#write (light_include_file, "#end //end if")
#fclose light_include_file



//sample positions and orientations
#fopen light_samples_info_file concat(light_name, "_spl_info.txt") write
#for(i, 0, res-1)
    #write (light_samples_info_file, light_pos_array[i])
    #write (light_samples_info_file, ", ")
    #write (light_samples_info_file, light_v1_array[i])
    #write (light_samples_info_file, ", ")
    #write (light_samples_info_file, light_v2_array[i])
    #write (light_samples_info_file, ",\n")
#end
#write (light_samples_info_file, max_bright_color)//
#fclose light_samples_info_file



//pre-trace ini file
#fopen light_ini_file concat(light_name, "_pretrace.ini") write
#write (light_ini_file, "Input_File_Name = \"")
#write (light_ini_file, concat(light_name, "_pretrace.pov"))
#write (light_ini_file, "\"\n")
#write (light_ini_file, "Width = 400\n")
#write (light_ini_file, "Height = 200\n")
#write (light_ini_file, "Initial_Frame = 1\n")
#write (light_ini_file, "Final_Frame = ")
#write (light_ini_file, res)
#write (light_ini_file, "\n")
#write (light_ini_file, "File_Gamma = 1.0\n")
#write (light_ini_file, "Antialias = On\n")
#write (light_ini_file, "Antialias_Threshold = 0.1\n")
#write (light_ini_file, "Sampling_Method = 1\n")
#write (light_ini_file, "Antialias_Depth = 3\n")
#fclose light_ini_file



//pre-trace pov file
#fopen light_pov_file concat(light_name, "_pretrace.pov") write
#write (light_pov_file, "#version 3.7;\n")
#write (light_pov_file, "#declare ", light_name, "_pretrace = 1;")
#write (light_pov_file, "#include \"", light_name, ".inc\"\n")
#write (light_pov_file, "#declare resolution = ")
#write (light_pov_file, str(res,0,0), ";\n")
#write (light_pov_file, "#declare lit_spl_pos_data = ", light_name, "_lit_spl_pos_data\n")
#write (light_pov_file, "#declare lit_spl_v1_data = ", light_name, "_lit_spl_v1_data\n")
#write (light_pov_file, "#declare lit_spl_v2_data = ", light_name, "_lit_spl_v2_data\n\n\n")
#write (light_pov_file, "//------------global settings------------\n")
#write (light_pov_file,
"global_settings{
assumed_gamma 1.0
max_trace_level 8\n"
)
#write (light_pov_file,
"    radiosity{
    count 40
    nearest_count 4
    error_bound 0.32
    recursion_limit 1
    low_error_factor 0.5
    gray_threshold 0.0
    brightness 1.0
    }
}
\n\n"
)
#write (light_pov_file, "//------------camera settings------------\n")
#write (light_pov_file,
"camera {
    spherical
    angle 360,180 
    location <0, 0, 0>
    look_at <0, 0, 0> + lit_spl_v1_data[frame_number-1]",
"    right -1
    sky vcross(lit_spl_v1_data[frame_number-1], lit_spl_v2_data[frame_number-1])
    translate lit_spl_pos_data[frame_number-1]
}\n\n\n")
#write (light_pov_file, "//------------pre-trace object------------\n")
#write (light_pov_file, light_name, "_look_like_for_pretrace")
#fclose light_pov_file

#end







